<?php
/**
 * WP Activity Log.
 *
 * @copyright Copyright (C) 2013-2024, Melapress - support@melapress.com
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License, version 3 or higher
 *
 * @wordpress-plugin
 * Plugin Name: WP Activity Log
 * Version:     4.6.4
 * Plugin URI:  https://melapress.com/wordpress-activity-log/
 * Description: Identify WordPress security issues before they become a problem. Keep track of everything happening on your WordPress, including users activity. Similar to Linux Syslog, WP Activity Log generates an activity log with a record of everything that happens on your WordPress websites.
 * Author:      Melapress
 * Author URI:  https://melapress.com/
 * Text Domain: wp-security-audit-log
 * Domain Path: /languages/
 * License:     GPL v3
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Network: true
 *
 * @package wsal
 *
 * @fs_premium_only /extensions/, /third-party/woocommerce/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

use WSAL\Helpers\WP_Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Require Composer autoloader if it exists.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'vendor/autoload.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';
}

if ( ! defined( 'WSAL_PREFIX' ) ) {
	define( 'WSAL_VERSION', '4.6.4' );
	define( 'WSAL_PREFIX', 'wsal_' );
	define( 'WSAL_PREFIX_PAGE', 'wsal-' );
}

// Plugin file.
if ( ! defined( 'WSAL_BASE_FILE_NAME' ) ) {
	define( 'WSAL_BASE_FILE_NAME', __FILE__ );
}

// Plugin Name.
if ( ! defined( 'WSAL_BASE_NAME' ) ) {
	define( 'WSAL_BASE_NAME', plugin_basename( __FILE__ ) );
}
// Plugin Directory URL.
if ( ! defined( 'WSAL_BASE_URL' ) ) {
	define( 'WSAL_BASE_URL', plugin_dir_url( __FILE__ ) );
}
// Plugin Directory Path.
if ( ! defined( 'WSAL_BASE_DIR' ) ) {
	define( 'WSAL_BASE_DIR', plugin_dir_path( __FILE__ ) );
}
// Plugin Docs URL.
if ( ! defined( 'WSAL_DOCS_URL' ) ) {
	define( 'WSAL_DOCS_URL', 'https://mellapress.com/support/' );
}
// Plugin Issue Reporting URL.
if ( ! defined( 'WSAL_ISSUE_URL' ) ) {
	define( 'WSAL_ISSUE_URL', 'https://wordpress.org/support/plugin/wp-security-audit-log' );
}
// Plugin Classes Prefix.
if ( ! defined( 'WSAL_CLASS_PREFIX' ) ) {
	define( 'WSAL_CLASS_PREFIX', 'WSAL_' );
}

/**
 * Connections Prefix.
 */
if ( ! defined( 'WSAL_CONN_PREFIX' ) ) {
	define( 'WSAL_CONN_PREFIX', 'connection-' );
}
if ( ! defined( 'WSAL_MIRROR_PREFIX' ) ) {
	define( 'WSAL_MIRROR_PREFIX', 'mirror-' );
}
// phpcs:disable
/* @free:start */
// phpcs:enable
if ( ! function_exists( 'wsal_disable_freemius_on_free' ) ) {
	/**
	 * Disables the freemius
	 *
	 * @return WSAL_Freemius
	 *
	 * @since 4.5.0
	 */
	function wsal_disable_freemius_on_free() {
		require_once __DIR__ . '/nofs/lib/class-wsal-freemius.php';

		return WSAL_Freemius::get_instance();
	}
}
add_filter( 'wsal_freemius_sdk_object', 'wsal_disable_freemius_on_free' );
add_filter( 'wsal_disable_freemius_sdk', '__return_true' );
// phpcs:disable
/* @free:end */
// phpcs:enable

if ( ! function_exists( 'wsal_freemius' ) ) {

	// phpcs:disable
	// phpcs:enable

	$prefixed_autoloader_file_path = WSAL_BASE_DIR . implode(
		DIRECTORY_SEPARATOR,
		array(
			'third-party',
			'vendor',
			'autoload.php',
		)
	);

	if ( file_exists( $prefixed_autoloader_file_path ) ) {
		require_once $prefixed_autoloader_file_path;
		// phpcs:disable
		// phpcs:enable
	}

	// Begin load sequence.
	WpSecurityAuditLog::get_instance();

	if ( is_admin() && ! WP_Helper::is_plugin_active( WSAL_BASE_NAME ) ) {
		WpSecurityAuditLog::load_freemius();

		if ( ! apply_filters( 'wsal_disable_freemius_sdk', false ) ) {
			wsal_freemius()->add_action( 'after_uninstall', array( '\WSAL\Helpers\Uninstall_Helper', 'uninstall' ) );
		}
	}
} elseif ( ! method_exists( 'WSAL_Freemius', 'set_basename' ) ) {
	global $wsal_freemius;
	$wsal_freemius = null;
	unset( $wsal_freemius );
} else {
	wsal_freemius()->set_basename( true, __FILE__ );
}
// phpcs:disable
/* @free:start */
// phpcs:enable
if ( ! function_exists( 'wsal_free_on_plugin_activation' ) ) {
	/**
	 * Takes care of deactivation of the premium plugin when the free plugin is activated. The opposite direction is handled
	 * by Freemius SDK.
	 *
	 * Note: This code MUST NOT be present in the premium version an is removed automatically during the build process.
	 *
	 * @since 4.3.2
	 */
	function wsal_free_on_plugin_activation() {
		$premium_version_slug = 'wp-security-audit-log-premium/wp-security-audit-log.php';
		if ( WP_Helper::is_plugin_active( $premium_version_slug ) ) {
			deactivate_plugins( $premium_version_slug, true );
		}
		$premium_version_slug = 'wp-security-audit-log-nofs/wp-security-audit-log.php';
		if ( WP_Helper::is_plugin_active( $premium_version_slug ) ) {
			deactivate_plugins( $premium_version_slug, true );
		}
	}

	register_activation_hook( __FILE__, 'wsal_free_on_plugin_activation' );
}
// phpcs:disable
/* @free:end */
// phpcs:enable
